#include "stdafx.h"
#include "Encoder.h"

Encoder::Encoder()
{
}

Encoder::~Encoder()
{
}

string Encoder::ConvertToCiphertext(string input, Printer prnt)
{
	// Initialize necessary variables.
	int i = 0;
	string curIV = prnt.iv;

	// Grab blocks piece by piece and encode them.
	while (i < input.length()) {
		string block = input.substr(i, i + prnt.pass.length());

		// Encode with both the IV and the password.
		block = Encode(block, curIV);
		block = Encode(block, prnt.pass);

		// Add to the ciphertext block and set the next IV.
		prnt.cphtxt += block;
		curIV = block;

		// Update the loop.
		i += prnt.pass.length();

	}

	// Return the built string.
	return prnt.cphtxt;

}

string Encoder::Encode(string key, string plaintext) 
{
	// Initialize necessary variables.
	string tempCipher = "";
	int i = 0;

	// Iterate through the plaintext, shifting each letter forward by the key's matching letter.
	if (key.length() != 0)
	{
		while (i < plaintext.length()) {
			tempCipher += ShiftLetter(plaintext.at(i), key.at(i % key.length()));
			i++;
		}
	}
	// If the key is empty, set equal to the plaintext.
	else
		tempCipher = plaintext;

	// Return the built string.
	return tempCipher;
}

string Encoder::Decode(string key, string ciphertext) 
{
	// Initialize necessary variables.
	string tempPlain = "";
	int i = 0;

	// Iterate through the ciphertext, shifting each letter back by the key's matching letter.
	if (key.length() != 0)
	{

		while (i < ciphertext.length()) {
			tempPlain += ShiftLetterBack(ciphertext.at(i), key.at(i % key.length()));
			i++;
		}
	}
	// If the key is empty, set equal to the ciphertext.
	else
		tempPlain = ciphertext;

	// Return the built string.
	return tempPlain;
}

char Encoder::ShiftLetter(char initial, char key) 
{
	// Add a letter to another to shift through the alphabet.
	int temp = initial - (int)'a';
	temp += (int)key - (int)'a';
	temp = temp % 26;
	initial = (char)temp;
	initial += 'a';

	// Return the shifted letter.
	return initial;
}

char Encoder::ShiftLetterBack(char initial, char key) 
{
	// Subtract a letter from another to shift through the alphabet.
	int temp = initial - (int)'a';
	temp -= ((int)key - (int)'a');
	temp += 26;
	temp = temp % 26;
	initial = (char)temp;
	initial += 'a';

	// Return the shifted letter.
	return initial;
}

string Encoder::CondenseString(string input) 
{
	// Initialize our return variable.
	string tempstring = "";
	
	// For each letter in the input, add it to our output.
	// Ignore non-letters and make everything lowercase.
	for (int i = 0; i < input.length(); i++) {
		if ((input.at(i) >= 'A' && input.at(i) <= 'Z') ||
			(input.at(i) >= 'a' && input.at(i) <= 'z'))
			tempstring += tolower(input.at(i));
	}

	// Return the built string.
	return tempstring;
}