#pragma once
#include <string>
#include "Printer.h"

using namespace std;

// Carries out the heavy lifting of encoding and decoding.
class Encoder
{
public:
	// Default constructor.
	Encoder();
	
	// Default destructor.
	~Encoder();

	// Turns string plaintext into a ciphertext.
	// Returns the ciphertext.
	string ConvertToCiphertext(string input, Printer prnt);

	// Encodes a given string one letter at a time.
	// Returns the encoded string.
	string Encode(string key, string plaintext);

	// Decodes a given string one letter at a time.
	// Returns the decoded string.
	string Decode(string key, string ciphertext);

	// Shifts a single letter forward by adding a value.
	// Returns the forward shifted letter.
	char ShiftLetter(char initial, char key);

	// Shifts a single letter backward by subtracting a value.
	// Returns the back shifted letter.
	char ShiftLetterBack(char initial, char key);

	// Condenses a string, removing symbols and turning all letters lowercase.
	// Returns the condensed string.
	string CondenseString(string input);
};

