﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CanterburySharp
{
	public class Act : INotifyPropertyChanged
	{
		public event PropertyChangedEventHandler PropertyChanged;
		public void RaisePropertyChange(string propertyName)
		{
			if (PropertyChanged != null)
			{
				PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
			}
		}

		string mName = "";
		List<Scene> mScenes = new List<Scene>();

		public Act(string name)
		{
			mName = name;
		}

		public string Name
		{
			get => mName; set
			{
				mName = value;
				RaisePropertyChange("Name");
			}
		}

		public List<Scene> Scenes
		{
			get => mScenes; set
			{
				mScenes = value;
				RaisePropertyChange("Scenes");
			}
		}

		public void AddNewScene(string name)
		{
			mScenes.Add(new Scene(name));
			RaisePropertyChange("Scenes");
		}


		public void DeleteScene(int index)
		{
			mScenes.RemoveAt(index);
			RaisePropertyChange("Scenes");
		}


	}
}
