﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CanterburySharp
{
	public class Direction : NotifyableObject
	{

		private string directionName = "";
		protected string directionValue = "";

		public Direction()
		{

		}
		public Direction(Direction dir)
		{
			directionName = dir.directionName;
			directionValue = dir.directionValue;
		}

		public virtual string DirectionValue
		{
			get => directionValue; set
			{
				directionValue = value;
				RaisePropertyChange("DirectionValue");
			}
		}
		public virtual string DirectionName
		{
			get => directionName; set
			{
				directionName = value;
				RaisePropertyChange("DirectionName");
			}
		}
	}
}
