﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CanterburySharp
{
	public class DirectionInput : Direction
	{
		public enum Comparison
		{
			Equal,
			LessThan,
			MoreThan,
			NotEqual,
			Contains,
			DoesNotContain
		}

		public enum Logic
		{
			And,
			Or
		}

		private Comparison comparisonValue;
		private Logic logicValue;
		private List<string> directionStrings = new List<string>();
		private int directionIndex;

		public DirectionInput()
		{

		}


		public DirectionInput(DirectionInput directionInput)
		{
			DirectionValue = directionInput.DirectionValue;
			if (directionInput.directionStrings.Count != 0)
			{
				DirectionStrings = directionInput.DirectionStrings;
				DirectionName = directionInput.DirectionName;
			}
			comparisonValue = directionInput.comparisonValue;
			logicValue = directionInput.logicValue;
			directionIndex = directionInput.directionIndex;
		}

		public int DirectionIndex
		{
			get => directionIndex; set
			{
				directionIndex = value;
				RaisePropertyChange("DirectionIndex");
			}
		}

		[JsonIgnore]
		public List<string> DirectionStrings
		{
			get => directionStrings; set
			{
				directionStrings = value;
				RaisePropertyChange("DirectionStrings");
			}
		}

		
		public override string DirectionName
		{
			get => DirectionStrings[DirectionIndex];
		}

		public Comparison ComparisonValue
		{
			get => comparisonValue; set
			{
				comparisonValue = value;
				RaisePropertyChange("ComparisonValueAsInt");
			}
		}

		[JsonIgnore]
		public int ComparisonValueAsInt
		{
			get => (int)comparisonValue; set
			{
				comparisonValue = (Comparison)value;
				RaisePropertyChange("ComparisonValueAsInt");
			}
		}

		public Logic LogicValue
		{
			get => logicValue; set
			{
				logicValue = value;
				RaisePropertyChange("LogicValueAsInt");
			}
		}

		[JsonIgnore]
		public int LogicValueAsInt
		{
			get => (int)logicValue; set
			{
				logicValue = (Logic)value;
				RaisePropertyChange("LogicValueAsInt");
			}
		}


	}
}
