﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CanterburySharp
{
	public class DirectionOutput : Direction
	{
		public enum Assignment
		{
			Equals,
			PlusEquals,
			MinusEquals
		}

		private Assignment assignmentValue;
		private List<string> directionStrings = new List<string>();
		private int directionIndex;

		public DirectionOutput()
		{

		}


		public DirectionOutput(DirectionOutput directionOutput)
		{
			DirectionValue = directionOutput.DirectionValue;
			if (directionOutput.directionStrings.Count !=0)
			{
				DirectionStrings = directionOutput.DirectionStrings;
				DirectionName = directionOutput.DirectionName;
			}
			assignmentValue = directionOutput.assignmentValue;
			directionIndex = directionOutput.directionIndex;
		}

		public int DirectionIndex
		{
			get => directionIndex; set
			{
				directionIndex = value;
				RaisePropertyChange("DirectionIndex");
			}
		}

		[JsonIgnore]
		public List<string> DirectionStrings
		{
			get => directionStrings; set
			{
				directionStrings = value;
				RaisePropertyChange("DirectionStrings");
			}
		}


		public override string DirectionName
		{
			get => DirectionStrings[DirectionIndex];
		}

		public Assignment AssignmentValue
		{
			get => assignmentValue; set
			{
				assignmentValue = value;
				RaisePropertyChange("AssignmentValueAsInt");
			}
		}

		[JsonIgnore]
		public int AssignmentValueAsInt
		{
			get => (int)assignmentValue; set
			{
				assignmentValue = (Assignment)value;
				RaisePropertyChange("AssignmentValueAsInt");
			}
		}

	}
}
