﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CanterburySharp
{
	/// <summary>
	/// Interaction logic for DirectionPage.xaml
	/// </summary>
	public partial class DirectionPage : Page
	{
		MainWindow mRootWindow;

		public DirectionPage()
		{
			InitializeComponent();

		}

		public DirectionPage(MainWindow main)
		{
			mRootWindow = main;
			InitializeComponent();
			AddAllDirections();

		}

		/// <summary>
		/// Add a group of directions
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void AddAllDirections()
		{
			foreach (var dir in mRootWindow.GetConversation().StageDirections)
			{
				var temp = AddStageDirectionView();
				temp.DirectionName.Text = dir.DirectionName;

				temp.DataContext = dir;
			}
		}

		/// <summary>
		/// Add a stage direction data
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void AddStageDirection(object sender, RoutedEventArgs e)
		{
			var temp = AddStageDirectionView();
			var dir = new Direction();

			mRootWindow.GetConversation().AddDirection(dir);
			temp.DataContext = dir;
			mRootWindow.LoadStageDirectionCombos();
		}

		/// <summary>
		/// Add a new stage direction view
		/// </summary>
		/// <returns></returns>
		private StageDirection AddStageDirectionView()
		{
			StageDirection sd = new StageDirection();
			StackPanel.Children.Add(sd);
			sd.Delete.Click += DeleteStageDirection;
			sd.DirectionName.TextChanged += TextChanged;
			sd.DirectionName.LostFocus += TextChanged;

			return sd;
		}

		/// <summary>
		/// Alter the value
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void TextChanged(object sender, RoutedEventArgs e)
		{
			mRootWindow.LoadStageDirectionCombos();
		}

		/// <summary>
		/// Get rid of this direction from the map
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DeleteStageDirection(object sender, RoutedEventArgs e)
		{
			Button b = (Button)(sender);
			StageDirection stageDirection = (StageDirection)VisualTreeHelper.GetParent(VisualTreeHelper.GetParent(VisualTreeHelper.GetParent(VisualTreeHelper.GetParent(b))));

			int index = StackPanel.Children.IndexOf(stageDirection);
			StackPanel.Children.RemoveAt(index);
			mRootWindow.GetConversation().DeleteDirection(index);
			mRootWindow.LoadStageDirectionCombos();
		}
	}
}
