﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CanterburySharp
{
	/// <summary>
	/// Interaction logic for DisplayEdge.xaml
	/// </summary>
	public partial class DisplayEdge : UserControl
	{
		public static readonly DependencyProperty BaseEdgeBrushProperty = DependencyProperty.Register("BaseEdgeBrush", typeof(Brush),
							typeof(DisplayEdge),
							new FrameworkPropertyMetadata(Brushes.White));

		public Brush BaseEdgeBrush
		{
			get { return (Brush)GetValue(BaseEdgeBrushProperty); }
			set { SetValue(BaseEdgeBrushProperty, value); }
		}

		public DisplayLine DisplaySource;
		public DisplayLine DisplayDestination;
		public Guid Guid;


		public DisplayEdge(Edge reply)
		{
			InitializeComponent();
			Guid = reply.Guid;
		}

		public void SetPosition()
		{
			if (DisplayDestination == null || DisplaySource == null)
			{
				Canvas.SetLeft(this, 0);
				Canvas.SetTop(this, 0);
				return;
			}

			int variation = -25;
			if (Canvas.GetTop(DisplaySource) > Canvas.GetTop(DisplayDestination))
				variation = 25;

			double topOffset = ((Canvas.GetTop(DisplaySource)) + (Canvas.GetTop(DisplayDestination))) / 2;
			double leftOffset = ((Canvas.GetLeft(DisplaySource)) + (Canvas.GetLeft(DisplayDestination))) / 2;

			Canvas.SetTop(this, ((topOffset + Canvas.GetTop(DisplayDestination)) / 2));
			Canvas.SetLeft(this, ((leftOffset + Canvas.GetLeft(DisplayDestination)) / 2) + 25 + variation);

			LineGeometry src = (LineGeometry)InputLine.Data;
			src.StartPoint = new Point(Canvas.GetLeft(DisplaySource) - Canvas.GetLeft(this) + 50, Canvas.GetTop(DisplaySource) - Canvas.GetTop(this) + 100);
			LineGeometry dst = (LineGeometry)OutputLine.Data;
			dst.EndPoint = new Point(Canvas.GetLeft(DisplayDestination) - Canvas.GetLeft(this) + 50, Canvas.GetTop(DisplayDestination) - Canvas.GetTop(this));

		}
	}
}
