﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CanterburySharp
{
	/// <summary>
	/// Interaction logic for Line.xaml
	/// </summary>
	public partial class DisplayLine : UserControl
	{
		public static readonly DependencyProperty BaseBorderBrushProperty =
		DependencyProperty.Register("BaseBorderBrush", typeof(Brush),
									typeof(DisplayLine),
									new FrameworkPropertyMetadata(Brushes.Black));

		public Brush BaseBorderBrush
		{
			get { return (Brush)GetValue(BaseBorderBrushProperty); }
			set { SetValue(BaseBorderBrushProperty, value); }
		}

		public static readonly DependencyProperty BaseBodyBrushProperty = DependencyProperty.Register("BaseBodyBrush", typeof(Brush),
							typeof(DisplayLine),
							new FrameworkPropertyMetadata(Brushes.White));

		public Brush BaseBodyBrush
		{
			get { return (Brush)GetValue(BaseBodyBrushProperty); }
			set { SetValue(BaseBodyBrushProperty, value); }
		}

		List<DisplayEdge> mOutputs = new List<DisplayEdge>();
		List<DisplayEdge> mInputs = new List<DisplayEdge>();

		public Guid Guid;
		public bool SelectedByMouse;
		public bool LoadedInMain;
		public bool ConnectedWithEdge;
		public bool Copied;

		public double OffsetTop = 0;
		public double OffsetLeft = 0;

		Brush mFill;
		Brush mStroke;

		public DisplayLine()
		{
			InitializeComponent();
			mFill = displayUI.Fill;
			mStroke = displayUI.Stroke;
		}

		public DisplayLine(DisplayLine dl)
		{
			InitializeComponent();
			this.displayUI.Height = dl.displayUI.Height;
			this.displayUI.Width = dl.displayUI.Height;
			this.displayUI.Fill = dl.displayUI.Fill;
			mFill = displayUI.Fill;
			mStroke = displayUI.Stroke;
		}


		public DisplayLine(Line line)
		{
			InitializeComponent();
			SpeakerText.Text = line.Speaker;
			DialogueText.Text = line.Dialogue;
			Guid = line.Guid;
			mFill = displayUI.Fill;
			mStroke = displayUI.Stroke;
		}


		public void SetEdgesInit()
		{
			foreach (var reply in mOutputs)
			{
				reply.SetPosition();
			}

			foreach (var reply in mInputs)
			{
				reply.SetPosition();
			}
		}

		public void AddAsSource(DisplayEdge toAdd)
		{
			mOutputs.Add(toAdd);
		}
		
		public void AddAsDestination(DisplayEdge toAdd)
		{
			mInputs.Add(toAdd);
			if (mInputs.Count > 0)
				ArrowHead.Visibility = Visibility.Visible;
		}

		public void RemoveAsSource(DisplayEdge toAdd)
		{
			mOutputs.Remove(toAdd);
		}

		public void RemoveAsDestination(DisplayEdge toAdd)
		{
			mInputs.Remove(toAdd);
			if (mInputs.Count == 0)
				ArrowHead.Visibility = Visibility.Hidden;
		}

		public bool UpdateInputs()
		{
			bool needsBounding = false;

			foreach (var rep in mOutputs)
			{
				rep.SetPosition();
			}

			return needsBounding;
		}

		public bool UpdateOutputs()
		{
			bool needsBounding = false;

			foreach (var rep in mInputs)
			{
				rep.SetPosition();
			}
			
			return needsBounding;
		}

		public void Selection(bool select)
		{
			SelectedByMouse = select;
			RestoreColor();
		}

		public void AddEdge(bool first)
		{

			ConnectedWithEdge = (first);
			RestoreColor();

		}

		public void LoadUp(bool inload)
		{
			LoadedInMain = (inload);
			RestoreColor();

		}


		public void CopyOut(bool toCopy)
		{
			Copied = (toCopy);
			RestoreColor();

		}

		public void RestoreColor()
		{
			if (SelectedByMouse) {
				displayUI.Stroke = Brushes.Red;
				displayUI.Fill = Brushes.Pink;
				displayUI.StrokeThickness = 2;
			}
			else if (ConnectedWithEdge) {
				displayUI.Stroke = Brushes.Blue;
				displayUI.Fill = Brushes.Cyan;
				displayUI.StrokeThickness = 2;
			}
			else if (Copied)
			{
				displayUI.Stroke = Brushes.Purple;
				displayUI.Fill = Brushes.MediumPurple;
				displayUI.StrokeThickness = 2;
			}
			else if (LoadedInMain) {
				displayUI.Stroke = Brushes.ForestGreen;
				displayUI.Fill = Brushes.LimeGreen;
				displayUI.StrokeThickness = 2;
			}
			else
			{
				displayUI.Stroke = mStroke;
				displayUI.Fill = mFill;
				displayUI.StrokeThickness = 1;
			}
						
		}

	}
}
