﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CanterburySharp
{
	public class Edge : NotifyableObject
	{

		private Vertex mSource;
		private Vertex mDestination;

		private Guid mGuid = Guid.NewGuid();
		private Guid mSourceGuid;
		private Guid mDestinationGuid;
		
		public Guid Guid { get => mGuid; set => mGuid = value; }

		public Guid SourceGuid { get => mSourceGuid; set => mSourceGuid = value; }

		public Guid DestinationGuid { get => mDestinationGuid; set => mDestinationGuid = value; }
		
		public Edge()
		{

		}

		public Edge(Edge edge)
		{
			mGuid = edge.mGuid;
			mSourceGuid = edge.mSourceGuid;
			mDestinationGuid = edge.mDestinationGuid;
		}

		[JsonIgnore]
		public Vertex Source { get => mSource; set
			{
				mSource = value;
				if (mSource != null)
					mSourceGuid = mSource.Guid;
				if (mDestination != null)
				{
					// ToDo: Old and busted
					//mSource.HorizontalPosition = mDestination.HorizontalPosition + 1;
					//mSource.VerticalPosition = mDestination.VerticalPosition + 1;
				}
				RaisePropertyChange("Source");
			}
		}

		[JsonIgnore]
		public Vertex Destination { get => mDestination; set
			{
				mDestination = value;
				if (mDestination != null)
					mDestinationGuid = mDestination.Guid;
				if (mSource != null)
				{
					// ToDo: Old and busted
					//mDestination.HorizontalPosition = mSource.Outputs.IndexOf(this);
					//mDestination.VerticalPosition = mSource.VerticalPosition + 1;
				}

				RaisePropertyChange("Destination");
			}
		}
	}
}
