﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CanterburySharp
{
	/// <summary>
	/// Interaction logic for MainPage.xaml
	/// </summary>
	public partial class FocusPage : Page
	{
		MainWindow mRootWindow;

		FullScript mFullScriptWindow;

		public int CurrentIndex = 0;

		bool mAutosave = false;

		public FocusPage(MainWindow main)
		{
			main.Undoing = true;
			mRootWindow = main;

			if (mRootWindow.GetConversation().Lines.Count == 0)
			{
				mRootWindow.GetConversation().InventLine();

				mRootWindow.GetConversation().Lines[0].Speaker = "Josh";
				mRootWindow.GetConversation().Lines[0].Dialogue = "Welcome to the prototype text interface! Start screwing around to see what happens.";
				mRootWindow.GetConversation().Lines[0].Root = true;
			}
			DataContext = mRootWindow.GetConversation().Lines[0];

			InitializeComponent();
			LoadInComboBoxes();
			ContextSwitch();
			main.Undoing = false;
		}

		/// <summary>
		/// Swap the loaded scene.
		/// </summary>
		public void ContextSwitch()
		{
			Index.Text = CurrentIndex.ToString();
			GUID.Text = mRootWindow.GetConversation().Lines[CurrentIndex].Guid.ToString();

			// Load Directions
			InputStackPanel.Children.Clear();
			OutputStackPanel.Children.Clear();

			for (int i = 0; i < mRootWindow.GetConversation().Lines[CurrentIndex].InputDirections.Count; ++i)
			{
				InputStackPanel.Children.Add(new StageDirectionCompare(mRootWindow.GetConversation().Lines[CurrentIndex].InputDirections[i]));
				((StageDirectionCompare)InputStackPanel.Children[InputStackPanel.Children.Count - 1]).Delete.Click += DeleteStageDirectionInput;
			}
			for (int i = 0; i < mRootWindow.GetConversation().Lines[CurrentIndex].OutputDirections.Count; ++i)
			{
				OutputStackPanel.Children.Add(new StageDirectionAssign(mRootWindow.GetConversation().Lines[CurrentIndex].OutputDirections[i]));
				((StageDirectionAssign)OutputStackPanel.Children[OutputStackPanel.Children.Count - 1]).Delete.Click += DeleteStageDirectionOutput;
			}

		}

		/// <summary>
		/// Reload the combo boxes.
		/// </summary>
		public void LoadInComboBoxes()
		{
			if (PrevDrop == null ||
				NextDrop == null ||
				AllDrop == null ||
				RootDrop == null)
				return;

			Line asLine = mRootWindow.GetConversation().Lines[CurrentIndex];

			List<string> prevNames = new List<string>();
			int counter = 0;
			int index = 0;
			if (PrevDrop.SelectedIndex != -1)
				index = PrevDrop.SelectedIndex;

			foreach (Edge reply in asLine.Inputs)
			{
				string assigned;
				if (((Line)reply.Source).Full.Length >= 16)
					assigned = ((Line)reply.Source).Full.Substring(0, 16);
				else
					assigned = ((Line)reply.Source).Full;

				prevNames.Add(counter + ": " + assigned + "...");
				++counter;
			}
			PrevDrop.ItemsSource = prevNames;
			if (asLine.Inputs.Count > 0)
				PrevDrop.SelectedIndex = index;

			List<string> nextNames = new List<string>();
			counter = 0;
			index = 0;
			if (NextDrop.SelectedIndex != -1)
				index = NextDrop.SelectedIndex;
			foreach (Edge reply in asLine.Outputs)
			{
				string aster = "";
				string assigned;
				if (reply.Source == null || reply.Destination == null)
					aster = "*";

				if (((Line)reply.Destination).Full.Length >= 16)
					assigned = ((Line)reply.Destination).Full.Substring(0, 16);
				else
					assigned = ((Line)reply.Destination).Full;

				nextNames.Add(aster + counter + ": " + assigned + "...");
				++counter;
			}
			NextDrop.ItemsSource = nextNames;
			if (asLine.Outputs.Count > 0)
				NextDrop.SelectedIndex = index;

			List<string> lineNames = new List<string>();
			counter = 0;
			index = CurrentIndex;
			if (AllDrop.SelectedIndex != -1)
				index = AllDrop.SelectedIndex;
			foreach (Line line in mRootWindow.GetConversation().Lines)
			{
				string assigned;
				if (line.Full.Length >= 16)
					assigned = line.Full.Substring(0, 16);
				else
					assigned = line.Full;

				assigned = counter + ": " + assigned + "...";
				if (line == asLine)
					assigned = "*" + assigned;

				lineNames.Add(assigned);
				++counter;
			}
			AllDrop.ItemsSource = lineNames;
			if (mRootWindow.GetConversation().Lines.Count > 0)
			{
				AllDrop.SelectedIndex = Math.Min(Math.Max(0, lineNames.Count - 1), index);
			}


			List<string> rootNames = new List<string>();
			counter = 0;
			index = 0;
			if (RootDrop.SelectedIndex != -1)
				index = RootDrop.SelectedIndex;
			foreach (Line line in mRootWindow.GetConversation().Lines)
			{
				if (!line.Root)
				{
					++counter;
					continue;
				}

				string assigned;
				if (line.Full.Length >= 16)
					assigned = line.Full.Substring(0, 16);
				else
					assigned = line.Full;

				assigned = counter + ": " + assigned + "...";
				if (line == asLine)
					assigned = "*" + assigned;

				rootNames.Add(assigned);
				++counter;
			}
			RootDrop.ItemsSource = rootNames;
			if (mRootWindow.GetConversation().Lines.Count > 0)
			{
				RootDrop.SelectedIndex = Math.Min(Math.Max(0, rootNames.Count - 1), index);
			}
		}

		/// <summary>
		/// Checks if there are any illegal edges
		/// </summary>
		/// <param name="rep"></param>
		/// <returns></returns>
		private bool HasDangles(Edge rep)
		{
			return HasDangleSource(rep) || HasDangleDestination(rep);
		}

		/// <summary>
		/// Check illegality upward
		/// </summary>
		/// <param name="rep"></param>
		/// <returns></returns>
		private bool HasDangleSource(Edge rep)
		{
			return rep.Source == null;
		}

		/// <summary>
		/// Check illegality downward
		/// </summary>
		/// <param name="rep"></param>
		/// <returns></returns>
		private bool HasDangleDestination(Edge rep)
		{
			return rep.Destination == null;
		}

		/// <summary>
		/// Go to the selected input
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void NewPrevGoTo(object sender, RoutedEventArgs e)
		{

			if (PrevDrop.SelectedIndex == -1)
			{
				MessageBox.Show("Please select which input we need to go to.");
				return;
			}
			CurrentIndex = mRootWindow.GetConversation().GetIndexLines(mRootWindow.GetConversation().Lines[CurrentIndex].Inputs[PrevDrop.SelectedIndex].Source);
			DataContext = mRootWindow.GetConversation().Lines[CurrentIndex];

			LoadInComboBoxes();
			ContextSwitch();
		}

		/// <summary>
		/// Go to the selected output
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void NewNextGoTo(object sender, RoutedEventArgs e)
		{

			if (NextDrop.SelectedIndex == -1)
			{
				MessageBox.Show("Please select which input we need to go to.");
				return;
			}
			CurrentIndex = mRootWindow.GetConversation().GetIndexLines(mRootWindow.GetConversation().Lines[CurrentIndex].Outputs[NextDrop.SelectedIndex].Destination);
			DataContext = mRootWindow.GetConversation().Lines[CurrentIndex];

			LoadInComboBoxes();
			ContextSwitch();
		}

		/// <summary>
		/// Add as an input
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void NewAddPrev(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			if (AllDrop.SelectedIndex != -1 && AllDrop.SelectedIndex != CurrentIndex)
				mRootWindow.GetConversation().MakeEdge(mRootWindow.GetConversation().Lines[AllDrop.SelectedIndex], mRootWindow.GetConversation().Lines[CurrentIndex]);
			LoadInComboBoxes();
			ReloadDisplay();
		}

		/// <summary>
		/// Remove as an input
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void NewDeletePrev(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			if (PrevDrop.SelectedIndex != -1)
				mRootWindow.GetConversation().DestroyEdge((Edge)mRootWindow.GetConversation().Lines[CurrentIndex].Inputs[PrevDrop.SelectedIndex]);
			LoadInComboBoxes();
			ReloadDisplay();
		}

		/// <summary>
		/// Add as an output
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void NewAddNext(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			if (AllDrop.SelectedIndex != -1 && AllDrop.SelectedIndex != CurrentIndex)
				mRootWindow.GetConversation().MakeEdge(mRootWindow.GetConversation().Lines[CurrentIndex], mRootWindow.GetConversation().Lines[AllDrop.SelectedIndex]);
			LoadInComboBoxes();
			ReloadDisplay();
		}

		/// <summary>
		/// Remove as an output
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void NewDeleteNext(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			if (NextDrop.SelectedIndex != -1)
				mRootWindow.GetConversation().DestroyEdge((Edge)mRootWindow.GetConversation().Lines[CurrentIndex].Outputs[NextDrop.SelectedIndex]);
			LoadInComboBoxes();
			ReloadDisplay();
		}

		/// <summary>
		/// Delete a line
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DeleteLine(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			if (AllDrop.SelectedIndex != -1 && AllDrop.SelectedIndex != CurrentIndex)
			{
				mRootWindow.GetConversation().DestroyLine(mRootWindow.GetConversation().Lines[AllDrop.SelectedIndex]);
				if (CurrentIndex >= mRootWindow.GetConversation().Lines.Count)
					CurrentIndex = mRootWindow.GetConversation().Lines.Count - 1;
			}

			LoadInComboBoxes();
			ContextSwitch();
			ReloadDisplay();
		}

		/// <summary>
		/// Make a new line
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void NewLine(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			mRootWindow.GetConversation().InventLine();
			CurrentIndex = mRootWindow.GetConversation().Lines.Count - 1;

			this.DataContext = mRootWindow.GetConversation().Lines[CurrentIndex];

			LoadInComboBoxes();
			ContextSwitch();
			ReloadDisplay();
		}

		/// <summary>
		/// Load up a new line
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void LoadSelectedLine(object sender, RoutedEventArgs e)
		{
			if (AllDrop.SelectedIndex != -1 && AllDrop.SelectedIndex != CurrentIndex)
			{
				CurrentIndex = AllDrop.SelectedIndex;
				this.DataContext = mRootWindow.GetConversation().Lines[CurrentIndex];

				LoadInComboBoxes();
				ContextSwitch();
				ReloadDisplay();
			}
		}

		/// <summary>
		/// Update the display view
		/// </summary>
		private void ReloadDisplay()
		{
			mRootWindow.ReloadDisplay();
		}

		/// <summary>
		/// Open the CYOA view
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FullScript(object sender, RoutedEventArgs e)
		{
			bool dangles = false;
			string indexes = "(";
			for (int i = 0; i < mRootWindow.GetConversation().Replies.Count; i++)
			{
				if (HasDangles(mRootWindow.GetConversation().Replies[i]))
				{
					dangles = true;
					indexes += i + ", ";
				}
			}
			indexes += ")";

			if (dangles)
			{

				MessageBox.Show("Hey, you have dangling edges! - " + indexes);
				return;
			}

			if (mFullScriptWindow != null)
				mFullScriptWindow.Close();

			int tempIndex = RootDrop.SelectedIndex;

			mFullScriptWindow = new FullScript(mRootWindow.GetConversation(), tempIndex);
			if (mFullScriptWindow.valid)
				mFullScriptWindow.Show();
		}

		/// <summary>
		/// Update the conversation from the display view
		/// </summary>
		public void UpdateConvoFromDisplay()
		{
			if (CurrentIndex < 0)
			{
				CurrentIndex = 0;
			}
			while (CurrentIndex >= mRootWindow.GetConversation().Lines.Count && CurrentIndex != 0)
			{
				CurrentIndex = Math.Max(CurrentIndex - 1, 0);
			}
			if (CurrentIndex >= 0)
				DataContext = mRootWindow.GetConversation().Lines[CurrentIndex];

			ContextSwitch();
			LoadInComboBoxes();
		}


		/// <summary>
		/// Update the stage direction selectors
		/// </summary>
		public void LoadStageDirectionCombos()
		{
			LoadStageDirectionInputCombos();
			LoadStageDirectionOutputCombos();
		}

		/// <summary>
		/// Update input combo boxes
		/// </summary>
		private void LoadStageDirectionInputCombos()
		{
			List<string> directions = new List<string>();
			foreach (var str in mRootWindow.GetConversation().StageDirections)
			{
				directions.Add(str.DirectionName);
			}

			foreach (var line in mRootWindow.GetConversation().Lines)
			{
				foreach (var element in line.InputDirections)
				{
					int tempIndex = element.DirectionIndex;
					element.DirectionStrings = directions;
					element.DirectionIndex = tempIndex;
				}
			}
		}

		/// <summary>
		/// Update output combo boxes
		/// </summary>
		private void LoadStageDirectionOutputCombos()
		{
			List<string> directions = new List<string>();
			foreach (var str in mRootWindow.GetConversation().StageDirections)
			{
				directions.Add(str.DirectionName);
			}

			foreach (var line in mRootWindow.GetConversation().Lines)
			{
				foreach (var element in line.OutputDirections)
				{
					int tempIndex = element.DirectionIndex;
					element.DirectionStrings = directions;
					element.DirectionIndex = tempIndex;
				}
			}
		}
		/// <summary>
		/// Add a new stage direction input
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void AddStageDirectionInput(object sender, RoutedEventArgs e)
		{

			mRootWindow.UpdateUndoList();
			mRootWindow.GetConversation().Lines[CurrentIndex].InputDirections.Add(new DirectionInput());

			StageDirectionCompare box1 = new StageDirectionCompare(mRootWindow.GetConversation().Lines[CurrentIndex].InputDirections.Last());

			InputStackPanel.Children.Add(box1);

			box1.Delete.Click += DeleteStageDirectionInput;
			LoadStageDirectionCombos();
		}

		/// <summary>
		/// delete stage direction input
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DeleteStageDirectionInput(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			Button b = (Button)(sender);
			StageDirectionCompare stageDirection = (StageDirectionCompare)VisualTreeHelper.GetParent(VisualTreeHelper.GetParent(VisualTreeHelper.GetParent(VisualTreeHelper.GetParent(b))));

			int index = InputStackPanel.Children.IndexOf(stageDirection);

			InputStackPanel.Children.RemoveAt(index);

			mRootWindow.GetConversation().Lines[CurrentIndex].RemoveInputDirection(index);
		}

		/// <summary>
		/// Add a new stage direction output
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void AddStageDirectionOutput(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			mRootWindow.GetConversation().Lines[CurrentIndex].OutputDirections.Add(new DirectionOutput());

			StageDirectionAssign box1 = new StageDirectionAssign(mRootWindow.GetConversation().Lines[CurrentIndex].OutputDirections.Last());
			OutputStackPanel.Children.Add(box1);

			box1.Delete.Click += DeleteStageDirectionOutput;
			LoadStageDirectionCombos();
		}

		/// <summary>
		/// delete stage direction output
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DeleteStageDirectionOutput(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			Button b = (Button)(sender);
			StageDirectionAssign stageDirection = (StageDirectionAssign)VisualTreeHelper.GetParent(VisualTreeHelper.GetParent(VisualTreeHelper.GetParent(VisualTreeHelper.GetParent(b))));

			int index = OutputStackPanel.Children.IndexOf(stageDirection);

			OutputStackPanel.Children.RemoveAt(index);

			mRootWindow.GetConversation().Lines[CurrentIndex].RemoveOutputDirection(index);
		}
		
		/// <summary>
		/// Reload combos when text changes
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ReloadCombosOnTextChange(object sender, TextChangedEventArgs e)
		{
			if (!mRootWindow.Undoing)
				mRootWindow.UpdateUndoList();
			LoadInComboBoxes();
		}

		/// <summary>
		/// Makes the current line a valid conversation entry
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void MakeRoot(object sender, RoutedEventArgs e)
		{
			mRootWindow.UpdateUndoList();
			LoadInComboBoxes();
		}
	}
}

