﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CanterburySharp
{
	public class Line : Vertex
	{
		private string mSpeaker = "<speaker>";
		private string mDialogue = "<line text>";

		List<DirectionOutput> mOutputDirections = new List<DirectionOutput>();
		List<DirectionInput> mInputDirections = new List<DirectionInput>();

		public Line()
		{

		}

		public Line(Line line)
		{
			mSpeaker = line.mSpeaker;
			mDialogue = (line.mDialogue);
			Guid = line.Guid;
			Root = line.Root;

			foreach (var input in line.InputDirections)
			{
				InputDirections.Add(new DirectionInput(input));
			}
			foreach (var output in line.OutputDirections)
			{
				OutputDirections.Add(new DirectionOutput(output));
			}

		}

		public void AddInputDirection(DirectionInput direction)
		{
			InputDirections.Add(direction);
		}

		public void AddOutputDirection(DirectionOutput direction)
		{
			OutputDirections.Add(direction);
		}

		public void RemoveInputDirection(int index)
		{
			InputDirections.RemoveAt(index);
		}

		public void RemoveOutputDirection(int index)
		{
			OutputDirections.RemoveAt(index);
		}

		public void ModifyInputDirection(int index, DirectionInput direction)
		{
			InputDirections[index] = direction;
		}

		public void ModifyOutputDirection(int index, DirectionOutput direction)
		{
			OutputDirections[index] = direction;
		}

		public string Speaker
		{
			get => mSpeaker; set
			{
				mSpeaker = value;
				RaisePropertyChange("Speaker");
			}
		}
		public string Dialogue
		{
			get => mDialogue; set
			{
				mDialogue = value;
				RaisePropertyChange("Dialogue");
			}
		}

		/// <summary>
		/// Get a combined speaker and dialogue string
		/// </summary>
		[JsonIgnore]
		public string Full
		{
			get => mSpeaker + " - " + mDialogue;

		}
		public List<DirectionOutput> OutputDirections { get => mOutputDirections; }
		public List<DirectionInput> InputDirections { get => mInputDirections; }
	}

}
