﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CanterburySharp
{
	public class Scene : NotifyableObject
	{
		string mName = "";
		List<Conversation> mConversations = new List<Conversation>();


		public Scene(string name)
		{
			mName = name;
		}

		public string Name
		{
			get => mName; set
			{
				mName = value;
				RaisePropertyChange("Name");
			}
		}

		public List<Conversation> Conversations
		{
			get => mConversations; set
			{
				mConversations = value;
				RaisePropertyChange("Conversations");
			}
		}

		/// <summary>
		/// Add a new conversation
		/// </summary>
		/// <param name="name"></param>
		public void AddNewConversation(string name)
		{
			mConversations.Add(new Conversation(name));
			RaisePropertyChange("Conversations");
		}

	}
}
