﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CanterburySharp
{
	public class Story : NotifyableObject
	{


		string mName = "";
		List<Act> mActs = new List<Act>();

		public string Name
		{
			get => mName; set
			{
				mName = value;
				RaisePropertyChange("Name");
			}
		}

		public List<Act> Acts
		{
			get => mActs; set
			{
				mActs = value;
				RaisePropertyChange("Acts");
			}
		}

		public void AddNewAct(string name)
		{
			mActs.Add(new Act(name));
			RaisePropertyChange("Acts");
		}


		public void DeleteAct(int index)
		{
			mActs.RemoveAt(index);
			RaisePropertyChange("Acts");
		}


	}
}
