#include "stdafx.h"
#include "FacadePokemonCenter.h"

using namespace std;

FacadePokemonCenter::FacadePokemonCenter() 
{

}

FacadePokemonCenter::~FacadePokemonCenter() 
{

}

FacadePokemonCenter::FacadePokemonCenter(int newID, string newName)
{
	// Take inputs for ID and name, instatiate all else.
	facadeID = newID;
	facadeName = newName;
	checkID = TrainerIDCheck();
	checkName = TrainerNameCheck();
	healandPC = HealAndPC();
	Welcome welcome();

}

int FacadePokemonCenter::GetTrainerID()
{

	return facadeID;
}

string FacadePokemonCenter::GetTrainerName()
{
	return facadeName;
}

void FacadePokemonCenter::HealPokemon()
{
	// Check that the ID is valid with your instance of TrainerIDCheck.
	// Check that the name is valid with your instance of TrainerNameCheck.
	// Check if the team has at least one Pokemon.

	if (checkID.TrainerActive(facadeID) &&
		checkName.TrainerActive(facadeName) &&
		!healandPC.IsTeamEmpty()) {

		// If every case is true, call the heal function in your instance of HealAndPC.
		// In addition, print that the healing was successful.

		healandPC.HealPokemon();
		cout << "Ok. We'll need your Pokemon." << endl;
		cout << "Thank you! Your Pokemon are fighting fit!" << endl;
		cout << "We hope to see you again!" << endl;
	}
	else {

		// Otherwise, do nothing, and say why the healing was not done.
		cout << "I'm sorry, but ";
		int errors = 0;
		if (!checkID.TrainerActive(facadeID)) {
			errors++;
			cout << "your ID does not match our records.";
		}
		if (!checkName.TrainerActive(facadeName)) {
			errors++;
			if (errors == 2)
				cout << " Also, ";
			cout << "your name does not match our records.";
		}
		if (healandPC.IsTeamEmpty()) {
			errors++;
			if (errors == 2) cout << " Also, ";
			if (errors == 3) cout << " Finally, ";
			cout << "you don't appear to have any Pokemon.";

		}
		cout << endl;

	}

}

void FacadePokemonCenter::DepositPokemon(int dexNum)
{
	// Check that the ID is valid with your instance of TrainerIDCheck.
	// Check that the name is valid with your instance of TrainerNameCheck.
	// Check if the team has at least one Pokemon.
	// Check if the team contains the given Pokemon.
	// Check if the Pokedex number is valid (that is to say, < 722).

	if (checkID.TrainerActive(facadeID)
		&& checkName.TrainerActive(facadeName)
		&& !healandPC.IsTeamEmpty()
		&& healandPC.ContainsPokemon(dexNum)
		&& dexNum < 722
		&& dexNum > -1)
	{
		// If every case is true, call the deposit function in your instance of HealAndPC.
		// In addition, print that the deposit was successful.

		healandPC.DepositPokemon(dexNum);
		cout << "We have deposited your Pokemon #" << dexNum << " successfully!" << endl;
	}

	else
	{
		// Otherwise, do nothing, and say why the deposit was not made.
		cout << "I'm sorry, but ";
		int errors = 0;
		if (!checkID.TrainerActive(facadeID)) {
			errors++;
			cout << "your ID does not match our records.";
		}
		if (!checkName.TrainerActive(facadeName)) {
			errors++;
			if (errors == 2)
				cout << " Also, ";
			cout << "your name does not match our records.";
		}
		if (!healandPC.ContainsPokemon(dexNum)) {
			errors++;
			if (errors > 1 && errors < 3) cout << " Also, ";
			if (errors == 3) cout << " Finally, ";
			
			cout << "you don't appear to own that Pokemon.";
			if (healandPC.IsTeamEmpty())
				cout << " In fact, you don't appear to have any Pokemon.";
			if (dexNum >= 722 || dexNum <= -1)
				cout << " And nobody owns that Pokemon, it doesn't exist!";

		}
		cout << endl;
	}

}

void FacadePokemonCenter::WithdrawPokemon(int dexNum)
{
	// Check that the ID is valid with your instance of TrainerIDCheck.
	// Check that the name is valid with your instance of TrainerNameCheck.
	// Check if the team has space for another Pokemon.
	// Check if the Pokedex number is valid (that is to say, < 722).

	if (checkID.TrainerActive(facadeID)
		&& checkName.TrainerActive(facadeName)
		&& !healandPC.IsTeamFull()
		&& dexNum < 722
		&& dexNum > -1)
	{
		// If every case is true, call the withdrawal function in your instance of HealAndPC.
		// In addition, print that the withdrawal was successful.

		healandPC.WithdrawPokemon(dexNum);
		cout << "We have withdrawn your Pokemon #" << dexNum << " successfully!" << endl;
	}

	else
	{
		// Otherwise, do nothing, and say why the withdrawal was not made.
		cout << "I'm sorry, but ";
		int errors = 0;
		if (dexNum >= 722 || dexNum <= -1) {
			cout << "nobody owns that Pokemon, it doesn't exist!" << endl;
			return;
		}
		if (!checkID.TrainerActive(facadeID)) {
			errors++;
			cout << "your ID does not match our records.";
		}
		if (!checkName.TrainerActive(facadeName)) {
			errors++;
			if (errors == 2)
				cout << " Also, ";
			cout << "your name does not match our records.";
		}
		if (healandPC.IsTeamFull()) {
			errors++;
			if (errors > 1 && errors < 3) cout << " Also, ";
			if (errors == 3) cout << " Finally, ";
			cout << "you are carrying too many Pokemon.";
		}
		cout << endl;
	}
}

void FacadePokemonCenter::PrintTeamAndHealth()
{
	// This just calls PrintTeamAndHealth() in the instance of HealAndPC.
	healandPC.PrintTeamAndHealth();
}
