#pragma once
#include <iostream>
#include <string>
#include <vector>
#include "HealAndPC.h"
#include "Pokemon.h"
#include "TrainerNameCheck.h"
#include "TrainerIDCheck.h"
#include "Welcome.h"

using namespace std;

class FacadePokemonCenter
{
private:
	// Private variables.
	// The expected ID for the user.
	int facadeID;
	// The expected name for the user.
	string facadeName;
	// The class for checking the ID.
	TrainerIDCheck checkID;
	// The class for checking the name.
	TrainerNameCheck checkName;
	// The class for depositing, withdrawing, and healing Pokemon.
	HealAndPC healandPC;
	// The class for welcoming new users.
	Welcome welcome;
public:
	// Default constructor.
	FacadePokemonCenter();

	// Default destructor.
	~FacadePokemonCenter();

	// Creates new facade based on the trainer's ID and name.
	FacadePokemonCenter(int newID, string newName);

	// Gets the trainer's ID.
	// Returns the trainerID variable.
	int GetTrainerID();

	// Gets the trainer's name.
	// Returns the trainerName variable.
	string GetTrainerName();

	// Heals every Pokemon on the trainer's team to 100%.
	void HealPokemon();

	// Deposits a Pokemon, removing them from the trainer's team.
	void DepositPokemon(int dexNum);

	// Withdraws a Pokemon, adding them to the trainer's team.
	// Will create a new Pokemon and add it to the team.
	void WithdrawPokemon(int dexNum);

	// Print out the name and health of each Pokemon on the team.
	void PrintTeamAndHealth();

};

