#include "stdafx.h"
#include "HealAndPC.h"

HealAndPC::HealAndPC()
{
	pokemonTeam.push_back(Pokemon(25));
	pokemonTeam.push_back(Pokemon(3));
	pokemonTeam.push_back(Pokemon(6));
	pokemonTeam.push_back(Pokemon(9));
	pokemonTeam.push_back(Pokemon(131));
	pokemonTeam.push_back(Pokemon(143));
}



HealAndPC::~HealAndPC() 
{

}

vector<Pokemon> HealAndPC::GetPokemonTeam()
{
	return pokemonTeam;
}

void HealAndPC::HealPokemon()
{
	// Heal every member of the team.
	for (it = pokemonTeam.begin(); it != pokemonTeam.end(); it++) 
		it->Heal();
}

void HealAndPC::DepositPokemon(int dexNum)
{
	// First, check if the team contains a Pokemon with the number.
	if (!ContainsPokemon(dexNum) || IsTeamEmpty())
		return;

	// If it is, find it in the list and remove it.
	for (it = pokemonTeam.begin(); it != pokemonTeam.end(); it++) 
	{
		if (it->GetPokedexNumber() == dexNum) 
		{
			pokemonTeam.erase(it);
			break;
		}
	}

}

void HealAndPC::WithdrawPokemon(int dexNum)
{
	// Disallow withdrawing if the team is already full.
	if (IsTeamFull())
		return;
	// Otherwise, push a new Pokemon in the team.
	pokemonTeam.push_back(Pokemon(dexNum));
}

bool HealAndPC::ContainsPokemon(int dexNum)
{
	// Looks for a Pokemon with a matching Pokedex number.
	for (it = pokemonTeam.begin(); it != pokemonTeam.end(); it++) {
		if (it->GetPokedexNumber() == dexNum)
			return true;
	}
	return false;
}

bool HealAndPC::IsTeamEmpty() 
{
	return pokemonTeam.size() == min_size;
}

bool HealAndPC::IsTeamFull() 
{ 
	return pokemonTeam.size() == max_size; 
}

void HealAndPC::PrintTeamAndHealth()
{
	cout << "The current team is as follows: " << endl;

	for (unsigned i = 0; i < pokemonTeam.size(); i++)
	{
		Pokemon cur = pokemonTeam.at(i);
		cout << "Pokedex number: " << cur.GetPokedexNumber() << "\n\tName: " << cur.GetPokemonName() << "\n\tHealth: " << cur.GetPercentHealth() << endl;
	}
}


