#pragma once
#include <iostream>
#include <string>
#include <vector>
#include "Pokemon.h"
#include "TrainerNameCheck.h"

using namespace std;

// Carries out the healing and PC operations of the class.
class HealAndPC
{
private:
	// Private variables.
	// The team of Pokemon.
	vector<Pokemon> pokemonTeam;
	// A tool to iterate through the team.
	vector<Pokemon>::iterator it;
	// Maximum size of the team.
	unsigned max_size = 6;
	// Minimum size of the team.
	unsigned min_size = 0;
public:
	// Constructor.
	// Adds a hardcoded list of Pokemon to the team.
	HealAndPC();

	// Default destructor.
	~HealAndPC();

	// Heals every Pokemon in the trainer's team.
	void HealPokemon();

	// Gets the Pokemon team.
	// Returns the pokemonTeam variable.
	vector<Pokemon> GetPokemonTeam();

	// Finds the first Pokemon with the given Pokedex number in the team and removes it from the team.
	void DepositPokemon(int dexNum);

	// Retrieves a Pokemon from the PC (that is, constructs a new Pokemon) and adds it to the team.
	void WithdrawPokemon(int dexNum);

	// Checks a team for a matching Pokemon.
	// Returns whether the team contains a Pokemon with the matching number.
	bool ContainsPokemon(int dexNum);

	// Checks the team's size.
	// Returns if the team size matches the const max_size.
	bool IsTeamEmpty();

	// Checks the team's size.
	// Returns if the team size matches the const min_size.
	bool IsTeamFull();

	// Prints each Pokemon on the team and their health.
	void PrintTeamAndHealth();
};

