//------------------------------------------------------------------
// University of Central Florida
// COP3503C - Spring 2016
// Program Author: Josh Wade
//------------------------------------------------------------------
// ** NOTE ** 
// This program was originally written in Java.
// The shell was created by the author as an assignment for his students.
// It has been filled out by the author and reformatted to C++ as part of a coding portfolio.

#include "stdafx.h"
#include <string>
#include <vector>
#include <iostream>
#include <time.h>
#include "FacadePokemonCenter.h"

using namespace std;

// Carries out test methods for the Facade.
// Provides options for grading and deducting points.
int main()
{
	// Seed randomness and initialize grading variables.
	srand(static_cast<int>(time(0)));
	double score = 45;
	vector<string> errors;
	int reply;

	// Create example facades.
	cout << "<Initializing test facades: >" << endl;
	FacadePokemonCenter goodNameAndID(01301, "Ash Ketchum");
	FacadePokemonCenter badNameGoodID(01301, "Gary Oak");
	FacadePokemonCenter goodNameBadID(74, "Ash Ketchum");


	
	// Test the healing method.
	cout << "\n<Testing healing: >" << endl;
	goodNameAndID.HealPokemon();
	cout << "\n<Check below: >" << endl;
	goodNameAndID.PrintTeamAndHealth();
	cout << "\n<Does every Pokemon have 100 health? (0 for no, 1 for yes.)>" << endl;

	// Grade the heal method.
	cin >> reply;
	if (reply == 1)
		score += 2.5;
	else
		errors.push_back("Error in healPokemon() : does not heal Pokemon correctly.");

	// Test the deposit method.
	cout << "\n<Check below: >" << endl;
	goodNameAndID.DepositPokemon(150);
	goodNameAndID.PrintTeamAndHealth();
	cout << "\n<Are there still 6 Pokemon on the team?(0 for no, 1 for yes.)>" << endl;

	// Grade the deposit method.
	cin >> reply;
	if (reply == 1)
		score += 5;
	else
		errors.push_back("Error in depositPokemon() : allows deposit when desired Pokemon is not on the trainers team.");

	// Deposit every Pokemon for further testing.
	goodNameAndID.DepositPokemon(25); 	// Pikachu
	goodNameAndID.DepositPokemon(3);	// Venusaur
	goodNameAndID.DepositPokemon(6);	// Charizard
	goodNameAndID.DepositPokemon(9);	// Blastoise
	goodNameAndID.DepositPokemon(131); 	// Lapras
	goodNameAndID.DepositPokemon(143); 	// Snorlax

	// Test the deposit method while team is empty.
	// Should print some error - either that pokemon is not in the team, or the list is empty.
	cout << "\n<Check below: >" << endl;
	goodNameAndID.DepositPokemon(150);
	cout << "\n<Is there an error for trying to deposit a Pokemon when the team is empty? (0 for no, 1 for yes.)>" << endl;

	// Grade the deposit method.
	cin >> reply;
	if (reply == 1)
		score += 5;
	else
		errors.push_back("Error in depositPokemon() : allows deposit when team is empty.");

	// Test deposit method for emptying teams.
	cout << "\n<Check below: >" << endl;
	goodNameAndID.PrintTeamAndHealth();
	cout << "\n<Is the team empty? (0 for no, 1 for yes.)>" << endl;

	// Grade the deposit method.
	cin >> reply;
	if (reply == 1)
		score += 5;
	else
		errors.push_back("Error in depositPokemon() : does not deposit Pokemon correctly.");

	// Withdraw Pokemon for further testing.
	goodNameAndID.WithdrawPokemon(201);	// Unown
	goodNameAndID.WithdrawPokemon(129);	// Magikarp
	goodNameAndID.WithdrawPokemon(370);	// Luvdisc
	goodNameAndID.WithdrawPokemon(124);	// Jynx
	goodNameAndID.WithdrawPokemon(11);	// Metapod
	goodNameAndID.WithdrawPokemon(399);	// Bidoof

	// Test the withdraw method.
	cout << "\n<Check below: >" << endl;
	goodNameAndID.PrintTeamAndHealth();
	cout << "\n<Are there 6 pokemon on the team? (0 for no, 1 for yes.)>" << endl;

	// Grade the withdraw method.
	cin >> reply;
	if (reply == 1)
		score += 5;
	else
		errors.push_back("Error in withdrawPokemon() : does not withdraw pokemon correctly.");

	// Test the withdraw method for a full team.
	cout << "\n<Check below: >" << endl;
	goodNameAndID.WithdrawPokemon(150);
	goodNameAndID.PrintTeamAndHealth();
	cout << "\n<Are there still only 6 Pokemon on the team? (0 for no, 1 for yes.)>" << endl;

	// Grade the withdraw method.
	cin >> reply;
	if (reply == 1)
		score += 5;
	else
		errors.push_back("Error in withdrawPokemon() : allows withdrawal of a 7th Pokemon to the team.");

	// Deposit Bidoof for further testing.
	goodNameAndID.DepositPokemon(399);

	// Test the withdraw method for nonexistent Pokemon.
	cout << "\n<Check below: >" << endl;
	goodNameAndID.WithdrawPokemon(999);
	goodNameAndID.PrintTeamAndHealth();
	cout << "\n<Are there five Pokemon on the team? (0 for no, 1 for yes.)>" << endl;

	// Grade the withdraw method.
	cin >> reply;
	if (reply == 1)
		score += 5;
	else
		errors.push_back("Error in withdrawPokemon() : allows withdrawal of invalid Pokemon to the team.");

	// Heal all Pokemon for further testing.
	goodNameAndID.HealPokemon();

	// Test the heal method for a new team.
	cout << "\n<Check below: >" << endl;
	goodNameAndID.PrintTeamAndHealth();
	cout << "\n<Does every Pokemon have 100 health? (0 for no, 1 for yes.)>" << endl;

	// Grade the heal method.
	cin >> reply;
	if (reply == 1)
		score += 2.5;

	// Test for bad name.
	cout << "\n<Check below: >" << endl;
	badNameGoodID.HealPokemon(); 		// Should print some error - Wrong name.
	badNameGoodID.DepositPokemon(25);	// Should print some error - Wrong name.
	badNameGoodID.WithdrawPokemon(25);	// Should print some error - Wrong name or too many pokemon on team.
	cout << "\n<Are there errors for an incorrect name? (0 for no, 1 for yes.)>" << endl;

	// Grade the bad name.
	cin >> reply;
	if (reply == 1)
		score += 10;
	else
		errors.push_back("Error in FacadePokemonCenter : does not check for correct name.");

	// Test for bad ID.
	cout << "\n<Check below: >" << endl;
	goodNameBadID.HealPokemon();		// Should print some error - Wrong ID.
	goodNameBadID.DepositPokemon(25);	// Should print some error - Wrong ID.
	goodNameBadID.WithdrawPokemon(25);	// Should print some error - Wrong ID or too many pokemon on team.
	cout << "\n<Are there errors for an incorrect ID? (0 for no, 1 for yes.)>" << endl;

	// Grade the bad ID.
	cin >> reply;
	if (reply == 1)
		score += 10;
	else
		errors.push_back("Error in FacadePokemonCenter : does not check for correct ID.");

	// Check for late days.
	cout << "---------\n\nHow many days late is the submission?" << endl;
	int daysLate;

	cin >> daysLate;
	bool late = false;
	if (daysLate > 0)
		late = true;

	// Get the final grade.
	double finalScore = score - (daysLate * 10);
	if (finalScore < 0)
		finalScore = 0;
	cout << "For this student, a score of " << finalScore << " %" << endl;

	// Print their errors.
	if (errors.size() != 0) 
	{
		cout << "Error List: " << endl;
		for (unsigned i = 0; i < errors.size(); i++)
			cout << errors.at(i) << endl;
	}

	// Indicate if they lost points for a late submission.
	if (late)
		cout << "-" << (daysLate * 10) << " points for a " << daysLate << " day late submission." << endl;

	// Close the program.
	cin.get();
	cin.get();

    return 0;
}
